<!-- Custom Language Selector Component -->
@props(['position' => 'bottom'])

<div class="relative" x-data="{ langOpen: false }" x-cloak>
    <button @click="langOpen = !langOpen"
            class="flex items-center space-x-2 px-3 py-2 text-sm bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 {{ $position === 'bottom' ? '' : 'w-full' }}">
        <i data-lucide="globe" class="w-4 h-4 text-gray-500 dark:text-gray-400"></i>
        <span class="{{ $position === 'bottom' ? '' : 'flex-1 text-left' }} text-gray-700 dark:text-gray-300">
            @php
                $currentLanguages = [
                    'en' => ['name' => 'English', 'flag' => '🇺🇸'],
                    'es' => ['name' => 'Español', 'flag' => '🇪🇸'],
                    'fr' => ['name' => 'Français', 'flag' => '🇫🇷'],
                    'de' => ['name' => 'Deutsch', 'flag' => '🇩🇪'],
                    'it' => ['name' => 'Italiano', 'flag' => '🇮🇹'],
                    'pt' => ['name' => 'Português', 'flag' => '🇵🇹'],
                    'ru' => ['name' => 'Русский', 'flag' => '🇷🇺'],
                    'zh' => ['name' => '中文', 'flag' => '🇨🇳'],
                    'ja' => ['name' => '日本語', 'flag' => '🇯🇵'],
                    'ko' => ['name' => '한국어', 'flag' => '🇰🇷'],
                    'ar' => ['name' => 'العربية', 'flag' => '🇸🇦'],
                    'hi' => ['name' => 'हिन्दी', 'flag' => '🇮🇳'],
                    'tr' => ['name' => 'Türkçe', 'flag' => '🇹🇷'],
                    'nl' => ['name' => 'Nederlands', 'flag' => '🇳🇱'],
                    'sv' => ['name' => 'Svenska', 'flag' => '🇸🇪'],
                    'da' => ['name' => 'Dansk', 'flag' => '🇩🇰'],
                    'no' => ['name' => 'Norsk', 'flag' => '🇳🇴'],
                    'fi' => ['name' => 'Suomi', 'flag' => '🇫🇮'],
                    'pl' => ['name' => 'Polski', 'flag' => '🇵🇱'],
                    'cs' => ['name' => 'Čeština', 'flag' => '🇨🇿'],
                    'hu' => ['name' => 'Magyar', 'flag' => '🇭🇺'],
                    'ro' => ['name' => 'Română', 'flag' => '🇷🇴'],
                    'bg' => ['name' => 'Български', 'flag' => '🇧🇬'],
                    'hr' => ['name' => 'Hrvatski', 'flag' => '🇭🇷'],
                    'sk' => ['name' => 'Slovenčina', 'flag' => '🇸🇰'],
                    'sl' => ['name' => 'Slovenščina', 'flag' => '🇸🇮'],
                    'et' => ['name' => 'Eesti', 'flag' => '🇪🇪'],
                    'lv' => ['name' => 'Latviešu', 'flag' => '🇱🇻'],
                    'lt' => ['name' => 'Lietuvių', 'flag' => '🇱🇹'],
                    'uk' => ['name' => 'Українська', 'flag' => '🇺🇦'],
                    'he' => ['name' => 'עברית', 'flag' => '🇮🇱'],
                    'th' => ['name' => 'ไทย', 'flag' => '🇹🇭'],
                    'vi' => ['name' => 'Tiếng Việt', 'flag' => '🇻🇳'],
                    'id' => ['name' => 'Bahasa Indonesia', 'flag' => '🇮🇩'],
                    'ms' => ['name' => 'Bahasa Melayu', 'flag' => '🇲🇾'],
                    'tl' => ['name' => 'Filipino', 'flag' => '🇵🇭'],
                ];
                $currentLocale = Session::get('locale', app()->getLocale());
                $currentLang = $currentLanguages[$currentLocale] ?? $currentLanguages['en'];
            @endphp
            @if($position === 'bottom')
                <span class="text-base mr-1">{{ $currentLang['flag'] }}</span>
            @else
                <span class="text-base mr-2">{{ $currentLang['flag'] }}</span>
                {{ $currentLang['name'] }}
            @endif
        </span>
        <i data-lucide="chevron-down" class="w-4 h-4 text-gray-400 transition-transform duration-200" :class="langOpen ? 'rotate-180' : ''"></i>
    </button>

    <div x-show="langOpen" @click.away="langOpen = false"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95 {{ $position === 'top' ? 'translate-y-1' : '-translate-y-1' }}"
         x-transition:enter-end="opacity-100 scale-100 translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 scale-100 translate-y-0"
         x-transition:leave-end="opacity-0 scale-95 {{ $position === 'top' ? 'translate-y-1' : '-translate-y-1' }}"
         class="absolute {{ $position === 'top' ? 'bottom-full mb-2' : 'top-full mt-2' }} {{ $position === 'bottom' ? 'right-0 w-64' : 'left-0 right-0' }} bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg shadow-lg z-50 max-h-60 overflow-y-auto" x-cloak>

        <div class="p-2 space-y-1">
            @foreach($currentLanguages as $code => $language)
                <a href="{{ route('language.switch', $code) }}"
                   class="flex items-center space-x-3 px-3 py-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-150 group {{ $currentLocale == $code ? 'bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}"
                   @click="langOpen = false">
                    <span class="text-lg">{{ $language['flag'] }}</span>
                    <span class="flex-1 text-sm font-medium">{{ $language['name'] }}</span>
                    @if($currentLocale == $code)
                        <i data-lucide="check" class="w-4 h-4 text-blue-600 dark:text-blue-400"></i>
                    @endif
                </a>
            @endforeach
        </div>
    </div>
</div>
